#include <ioCC2530.h>
#include "SPI_TFT.H"
#include "Font.H"
#include "delay.h"
#define LCD_COMMAND 0x00
#define LCD_DATA    0x01

#define LCD_MAX_BUF 25

#define SOFTWARE_SPI
//#define HARDWARE_SPI  //LCDƲӲSPI

#define COL_SPACE   2   //ַ
#define ROW_SPACE   4   //м
#define ALL_CNS     128

// SPI TFT LCD˿ڶ
#define LCD_DC                 P0_0  // /ѡ, L_R
#define LCD_SDA                P1_3  // ˫, L_D  P1_6   P1_3
#define LCD_SCL                P1_2  // ʱ, L_C P1_2  P1_5
//#define LCD_CS               P1_2  // Ƭѡ, L_S Ƭѡӵ
#define LCD_RST                P1_7  // lcdλ   

//Һƿ1궨
//#define LCD_CS_SET  	(LCD_CS_CLRx01)   
#define	LCD_DC_SET  	(LCD_DC = 0x01)  
#define	LCD_SDA_SET  	(LCD_SDA = 0x01)    
#define	LCD_SCL_SET  	(LCD_SCL = 0x01)   
#define	LCD_RST_SET  	(LCD_RST = 0x01)  

//Һƿ0궨
//#define LCD_CS_CLR  	(LCD_CS_CLRx00)    
#define	LCD_DC_CLR  	(LCD_DC = 0x00)  
#define	LCD_SDA_CLR  	(LCD_SDA = 0x00)     
#define	LCD_SCL_CLR  	(LCD_SCL = 0x00)
#define	LCD_RST_CLR  	(LCD_RST = 0x00)   


void SPI_Init(void);
void LCD_clear(unsigned int color);
void LCD_write_EN_string(unsigned char X,unsigned char Y,uint8 *s);
static void LCD_set_window(unsigned int X, unsigned int Y, 
                           unsigned Width,unsigned int Height);
static void LCD_write_EN(unsigned int X, unsigned int Y, unsigned char c);
static void LCD_write_CN(unsigned int X, unsigned int Y, unsigned char c);

extern void DelayMS(unsigned int msec);

unsigned int  Color    = YELLOW; // ǰɫ
unsigned int  Color_BK = BLUE;   // ɫ



//SPIߴһ8λ
void  SendByte(unsigned char Data)
{
  unsigned char i=0;
  
  for(i=8;i>0;i--)
  {
    if(Data&0x80)	
      LCD_SDA_SET;//
    else 
      LCD_SDA_CLR;
    
    LCD_SCL_CLR;       
    LCD_SCL_SET;
    Data<<=1; 
  }
}

//SPIߴһ8λ
void  SPI_WriteData(unsigned char Data)
{
  unsigned char i=0;
  
  for(i=8;i>0;i--)
  {
    if(Data&0x80)	
      LCD_SDA_SET;//
    else 
      LCD_SDA_CLR;
    
    LCD_SCL_CLR;       
    LCD_SCL_SET;
    Data<<=1; 
  }
}

//Һдһ8λָ
void Lcd_WriteIndex(unsigned char Index)
{ 
  //LCD_CS_CLR;  //ALD del  SPIдʱʼ
  LCD_DC_CLR;
  SPI_WriteData(Index);
  //LCD_CS_SET;  //ALD del
}

//Һдһ8λ
void Lcd_WriteData(unsigned char Data)
{
  //LCD_CS_CLR;  //ALD del
  LCD_DC_SET;
  SPI_WriteData(Data);
  //LCD_CS_SET;  //ALD del 
}

//Һдһ16λ
void LCD_WriteData_16Bit(unsigned short Data)
{
  //LCD_CS_CLR;  //ALD del
  LCD_DC_SET;
  SPI_WriteData(Data>>8); //д8λ
  SPI_WriteData(Data); 	  //д8λ
  //LCD_CS_SET;  //ALD del 
}

/****************************************************************************
*     : LCD_write_byte()
*     : ݵLCD 
* ڲ: data    д
*           command д/ѡ  
* ڲ:  
****************************************************************************/
static void LCD_write_byte(unsigned char data, unsigned char command)
{
  ////LCD_CS_CLR ;// ʹLCD
  if (command == 0)
    Lcd_WriteIndex(data); // 
  else
    Lcd_WriteData(data) ; // 
  //SendByte(data);
  //LCD_CS_SET; // رLCD
  //LCD_DC_SET;	
}

/****************************************************************************
*     : SPI_Init()
*     : ʼӲSPIӿ
* ڲ: 
* ڲ: 
****************************************************************************/
void SPI_Init(void)
{
  PERCFG |= 0x02; //UART1ΪSPIģʽ
  P1SEL  |= 0x60; //P16/P15ΪSPI豸
  U1BAUD  = 0x00; 
  U1CSR   = 0x00;
  U1GCR   = 0xF3; //SPICLK=ϵͳʱ/2, ģʽ, MSBǰ
}

// λlcd
void Lcd_Reset(void)
{
  LCD_RST_CLR;
  DelayMS(150);
  LCD_RST_SET;
  DelayMS(50);
}

//ʼSPIӿڲɫTFTҺΪST7735 
void InitLcd(void)
{
  P0SEL &= 0xFE; //P00ΪͨIOڣ
  P0DIR |= 0x01; //P00Ϊ
  P1SEL &= 0x73; //P12P13,P17ΪͨIO
  P1DIR |= 0x8c; //P12P13,P17Ϊ 

  Lcd_Reset();
  
#ifdef HARDWARE_SPI                                         
  P1DIR &= 0x9F;
  SPI_Init();   //ʼSPI˿  
#endif
 
  LCD_write_byte(0x11,LCD_COMMAND); //˳˯ģʽ
  DelayMS(1); 

  ///ST7735R Frame Rate
  LCD_write_byte(0xB1,LCD_COMMAND); 
  LCD_write_byte(0x01,LCD_DATA); 
  LCD_write_byte(0x2C,LCD_DATA); 
  LCD_write_byte(0x2D,LCD_DATA); 
  LCD_write_byte(0xB2,LCD_COMMAND); 
  LCD_write_byte(0x01,LCD_DATA); 
  LCD_write_byte(0x2C,LCD_DATA); 
  LCD_write_byte(0x2D,LCD_DATA); 
  LCD_write_byte(0xB3,LCD_COMMAND); 
  LCD_write_byte(0x01,LCD_DATA); 
  LCD_write_byte(0x2C,LCD_DATA); 
  LCD_write_byte(0x2D,LCD_DATA); 
  LCD_write_byte(0x01,LCD_DATA); 
  LCD_write_byte(0x2C,LCD_DATA); 
  LCD_write_byte(0x2D,LCD_DATA); 

  LCD_write_byte(0xB4,LCD_COMMAND);//жԵ
  LCD_write_byte(0x07,LCD_DATA); 
  //ST7735Rӵ
  LCD_write_byte(0xC0,LCD_COMMAND); 
  LCD_write_byte(0xA2,LCD_DATA); 
  LCD_write_byte(0x02,LCD_DATA); 
  LCD_write_byte(0x84,LCD_DATA); 
  LCD_write_byte(0xC1,LCD_COMMAND); 
  LCD_write_byte(0xC5,LCD_DATA); 
  LCD_write_byte(0xC2,LCD_COMMAND); 
  LCD_write_byte(0x0A,LCD_DATA); 
  LCD_write_byte(0x00,LCD_DATA); 
  LCD_write_byte(0xC3,LCD_COMMAND); 
  LCD_write_byte(0x8A,LCD_DATA); 
  LCD_write_byte(0x2A,LCD_DATA); 
  LCD_write_byte(0xC4,LCD_COMMAND); 
  LCD_write_byte(0x8A,LCD_DATA); 
  LCD_write_byte(0xEE,LCD_DATA); 

  LCD_write_byte(0xC5,LCD_COMMAND); //VCOM 
  LCD_write_byte(0x0E,LCD_DATA); 

  LCD_write_byte(0x36,LCD_COMMAND); //RGBģʽ 
  LCD_write_byte(0xC8,LCD_DATA); 
  
  // ST7735R Gamma У
  LCD_write_byte(0xe0,LCD_COMMAND); 
  LCD_write_byte(0x0f,LCD_DATA); 
  LCD_write_byte(0x1a,LCD_DATA); 
  LCD_write_byte(0x0f,LCD_DATA); 
  LCD_write_byte(0x18,LCD_DATA); 
  LCD_write_byte(0x2f,LCD_DATA); 
  LCD_write_byte(0x28,LCD_DATA); 
  LCD_write_byte(0x20,LCD_DATA); 
  LCD_write_byte(0x22,LCD_DATA); 
  LCD_write_byte(0x1f,LCD_DATA); 
  LCD_write_byte(0x1b,LCD_DATA); 
  LCD_write_byte(0x23,LCD_DATA); 
  LCD_write_byte(0x37,LCD_DATA); 
  LCD_write_byte(0x00,LCD_DATA); 

  LCD_write_byte(0x07,LCD_DATA); 
  LCD_write_byte(0x02,LCD_DATA); 
  LCD_write_byte(0x10,LCD_DATA); 
  LCD_write_byte(0xe1,LCD_COMMAND); 
  LCD_write_byte(0x0f,LCD_DATA); 
  LCD_write_byte(0x1b,LCD_DATA); 
  LCD_write_byte(0x0f,LCD_DATA); 
  LCD_write_byte(0x17,LCD_DATA); 
  LCD_write_byte(0x33,LCD_DATA); 
  LCD_write_byte(0x2c,LCD_DATA); 
  LCD_write_byte(0x29,LCD_DATA); 
  LCD_write_byte(0x2e,LCD_DATA); 
  LCD_write_byte(0x30,LCD_DATA); 
  LCD_write_byte(0x30,LCD_DATA); 
  LCD_write_byte(0x39,LCD_DATA); 
  LCD_write_byte(0x3f,LCD_DATA); 
  LCD_write_byte(0x00,LCD_DATA); 
  LCD_write_byte(0x07,LCD_DATA); 
  LCD_write_byte(0x03,LCD_DATA); 
  LCD_write_byte(0x10,LCD_DATA);  

  LCD_write_byte(0x2a,LCD_COMMAND);
  LCD_write_byte(0x00,LCD_DATA);
  LCD_write_byte(0x00,LCD_DATA);
  LCD_write_byte(0x00,LCD_DATA);
  LCD_write_byte(0x7f,LCD_DATA);
  LCD_write_byte(0x2b,LCD_COMMAND);
  LCD_write_byte(0x00,LCD_DATA);
  LCD_write_byte(0x00,LCD_DATA);
  LCD_write_byte(0x00,LCD_DATA);
  LCD_write_byte(0x9f,LCD_DATA);

  LCD_write_byte(0xF0,LCD_COMMAND); //ʹܲ  
  LCD_write_byte(0x01,LCD_DATA); 
  LCD_write_byte(0xF6,LCD_COMMAND); //رramʡģʽ 
  LCD_write_byte(0x00,LCD_DATA); 

  LCD_write_byte(0x3A,LCD_COMMAND); //ɫ16bit 
  LCD_write_byte(0x05,LCD_DATA); 
  
  LCD_write_byte(0x29,LCD_COMMAND); //ʾ  
  LCD_clear(WINDOW_BK_COLOR);       //Աɫ 
}

/****************************************************************************
*     : LCD_clear()
*     : ָɫ
* ڲ: color ɫ
* ڲ: 
****************************************************************************/
void LCD_clear(unsigned int color)
{
  register unsigned int  i=0,j=0;
  register unsigned char ch;
  register unsigned char cl;
  
  LCD_set_window(0,0,X_MAX_PIXEL,Y_MAX_PIXEL);
  ch = color>>8;
  cl = color&0xFF;
  LCD_write_byte(0x2C,LCD_COMMAND);
  //LCD_CS_CLR;
  LCD_DC_SET;
  for (i=0;i<Y_MAX_PIXEL;i++)
    for (j=0;j<2;j++)
    {
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);      
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
    }
  LCD_DC_SET;
  //LCD_CS_SET;
}

/****************************************************************************
*     : LCD_set_window()
*     : ʾ
* ڲ: X - ʾϽǺ      Y ʾϽ
*           Width ʾڿ          Height ʾڸ߶
* ڲ: 
****************************************************************************/
static void LCD_set_window(unsigned int X    , unsigned int Y, 
                           unsigned int Width, unsigned int Height)
{
  LCD_write_byte(0x2A,LCD_COMMAND);         //еַ
  LCD_write_byte(X>>8,LCD_DATA) ;           //ʾϽǺλ
  LCD_write_byte((X+2)&0xFF,LCD_DATA);      //ʾϽǺλ 	
  LCD_write_byte((X+Width+1)>>8,LCD_DATA);  //ÿȸλ 	
  LCD_write_byte((X+Width+1)&0xFF,LCD_DATA);// ÿȵλ 	
  
  LCD_write_byte(0x2B,LCD_COMMAND);         //еַ
  LCD_write_byte(Y>>8,LCD_DATA) ;           //ʾϽλ
  LCD_write_byte((Y+3)&0xFF,LCD_DATA);      //ʾϽλ 
  LCD_write_byte((Y+Height+2)>>8,LCD_DATA); // ʾڸ߶ȸλ 	
  LCD_write_byte((Y+Height+2)&0xFF,LCD_DATA);// ʾڸ߶ȵλ 	  
  LCD_write_byte(0x2C,LCD_COMMAND) ;
}

/****************************************************************************
*     : DrawPixel()
*     : ָλָɫʾ
****************************************************************************/
void DrawPixel(unsigned int x, unsigned int y, unsigned int color)
{
  //LCD_set_XY(x,y);  //趨ʾλ andy
  LCD_write_byte(color>>8,LCD_DATA);  //ʾɫݸλֽ
  LCD_write_byte(color&0xFF,LCD_DATA);//ʾɫݵλֽ
}

/****************************************************************************
*     : DrawVerticalLine()
*     : ָλָɫֱ
* ڲ: X - ֱʼλú      Y ֱʼλ
*           Length ֱ߳           Color ֱɫ
* ڲ: 
****************************************************************************/
void DrawVerticalLine(unsigned int x, unsigned int y, 
                      unsigned int Length,unsigned int Color)               
{
  register int  index = 0;
  register char ch,cl;
  
  ch = (unsigned char)(Color>>8);
  cl = (unsigned char)(Color);
  LCD_set_window(x,y,1,Length);
  for(index=0;index<Length;index++)
  {
  LCD_write_byte(ch,LCD_DATA) ;
  LCD_write_byte(cl,LCD_DATA) ;
  }
}

/****************************************************************************
*     : DrawHorizonLine()
*     : ָλָɫˮƽ
* ڲ: X - ˮƽʼλú      Y ˮƽʼλ
*           Length ˮƽ߳           Color ˮƽɫ
* ڲ: 
****************************************************************************/
void DrawHorizonLine(unsigned int x, unsigned int y, 
                     unsigned int Length,unsigned int Color)               
{
  register int  index = 0;
  register char ch,cl;
  
  ch = (unsigned char)(Color>>8);
  cl = (unsigned char)(Color);
  LCD_set_window(x,y,Length,1);
  for(index=0;index<Length;index++)
  {
    LCD_write_byte(ch,LCD_DATA);
    LCD_write_byte(cl,LCD_DATA);
  }
}

/****************************************************************************
*     : DrawRect()
*     : ָλָɫ
* ڲ: X - ʼλú      Y ʼλ
*           Width  ο           Height θ߶                   
*           Color  ɫ             
* ڲ: 
****************************************************************************/
void DrawRect(unsigned int Xpos, unsigned int Ypos, unsigned int Width, 
              unsigned int Height,unsigned Color)
{
  DrawHorizonLine(Xpos, Ypos, Width, Color) ;
  DrawHorizonLine(Xpos, (Ypos + Height), Width, Color) ;
  DrawVerticalLine(Xpos, Ypos, Height, Color) ;
  DrawVerticalLine((Xpos+Width-1) ,Ypos, Height, Color);
}

/****************************************************************************
*     : DrawRectFill()
*     : ָλָɫ
* ڲ: X - ʼλú      Y ʼλ
*           Width  ο           Height θ߶                   
*           Color  ɫ             
* ڲ: 
****************************************************************************/
void DrawRectFill(unsigned int Xpos  , unsigned int Ypos, unsigned int Width, 
                  unsigned int Height, unsigned Color                        )
{
  register unsigned int i;
  register unsigned int index = Width*Height/16+1;
  register char ch,cl;
  
  ch = (unsigned char)(Color>>8);
  cl = (unsigned char)(Color);
  LCD_set_window(Xpos,Ypos,Width,Height);
  LCD_write_byte(0x2C,LCD_COMMAND);
  //LCD_CS_CLR ; andy
  LCD_DC_SET ;
  for(i=0;i<index;i++)
  {
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl); 
      SendByte(ch);
      SendByte(cl);      
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
      SendByte(ch);
      SendByte(cl);
  }    
}

/****************************************************************************
*     : LCD_write_EN()
*     : ָλʾ 7 14 ASCIIַ 
* ڲ: X - ʾλϽǺ      Y ʾλϽ
*           c ʾַ                  
* ڲ: 
****************************************************************************/
static void LCD_write_EN(unsigned int X, unsigned int Y, unsigned char c)
{
  unsigned char i,j,temp;
  
  LCD_set_window(X,Y,7,14);
  //LCD_CS_CLR ;
  LCD_DC_SET ;
  for(i=0;i<14;i++)
  {
    temp = ASCII7x14[c-32][i];
    for(j=0;j<7;j++)
    {
      if(temp&0x80)
      {
        SendByte(Color>>8);  
        SendByte(Color) ;
      }
      else
      {
        SendByte(Color_BK>>8) ;  
        SendByte(Color_BK);
      }            
      temp <<= 1 ;
    }
  }
  //LCD_CS_SET ; andy
  LCD_DC_SET ;
}

/****************************************************************************
*     : LCD_write_EN_string()
*     : ָλʾ 7 14 ASCIIַ 
* ڲ: X - ʾλϽǺ      Y ʾλϽ
*           s ַָ                  
* ڲ: 
****************************************************************************/
void LCD_write_EN_string(unsigned char X,unsigned char Y,uint8 *s)
{
  unsigned char i=0;
  
  while (*s)
  {
    LCD_write_EN(X+i*7,Y,*s);
    s++;
    i++;
    if(i>=HAL_LCD_MAX_CHARS)return;
  }
  return;
}

/****************************************************************************
*     : LCD_write_CN()
*     : ָλʾ 14 14 ַ  
* ڲ: X - ʾλϽǺ      Y ʾλϽ
*           c ʾַָ                  
* ڲ: 
****************************************************************************/
static void LCD_write_CN(unsigned int X, unsigned int Y, unsigned char c)
{
  unsigned char i,j,temp;
  
  LCD_set_window(X,Y,14,14);  //ַСʾ
  //LCD_CS_CLR;               //ҺSPIʹandy
  LCD_DC_SET;                 //źʹ
  for(i=0;i<28;i++)           // 14x14ַݴСΪ2x14=28ֽ
  {
    temp = CN14x14[c][i] ;    //ģ
    for(j=0;j<8;j++)          // λʾ
    {
      if(temp&0x80)           //λֵΪ1ʾַɫ
      {
        SendByte(Color>>8);  
        SendByte(Color) ;
      }
      else                    //λֵΪ0ʾɫ
      {
        SendByte(Color_BK>>8) ;  
        SendByte(Color_BK);
      }            
      temp <<= 1 ;
    }
    i++ ;                     //ָһֽ
    temp = CN14x14[c][i];
    for(j=0;j<6;j++)          // λʾΪ14أ
    {                         // ÿе2ֽ2λ
      if(temp&0x80)           // λֵΪ1ʾַɫ
      {
        SendByte(Color>>8);  
        SendByte(Color) ;
      }
      else                    // λֵΪ0ʾɫ
      {
        SendByte(Color_BK>>8) ;  
        SendByte(Color_BK);
      }            
      temp <<= 1 ;
    }
  }
  //LCD_CS_SET;               //ҺSPIֹ
  LCD_DC_SET;                 //ݿźŽֹ
}

/****************************************************************************
*     : LCD_write_CN_string()
*     : ָλʾ 14 14 ַ   
* ڲ: X - ʾλϽǺ      Y ʾλϽ
*           s ַָ                  
* ڲ: 
****************************************************************************/
void LCD_write_CN_string(unsigned char X,unsigned char Y,uint8 *s)
{
  unsigned char i=0;
  static unsigned char j=0;
  while (*s)
  {
    for(j=0;j<ALL_CNS;j++)                  //ģ
    { 
      if(  *s    ==CN14x14_Index[j*2]            
         &&*(s+1)==CN14x14_Index[j*2+1])    //ģ
      {
        LCD_write_CN(X+i*14,Y,j) ;          //ʾ
        break; 
      }
    }
    if(j>=ALL_CNS)                          //޴ֵĵģ
    {
      DrawRectFill(X+i*14,Y,14,14,Color_BK);//ʾո
    }
    s++; s++ ;                              //ַָλ
    i++;
    if(i>=HAL_LCD_MAX_CHARS/2)  
      return;                               //ʾַ
  }
  return ;
}

/****************************************************************************
*     : ShowImage()
*     : ʾͼƬ   
* ڲ: p - ͼƬ  ȡģʽ ˮƽɨ  λǰ           
* ڲ: 
****************************************************************************/
void ShowImage(const unsigned char *p) 
{
  int i; 
  unsigned char picH,picL;
  //LCD_clear(White); //
  
  LCD_set_window(24,5,80,40); //
  for(i=0;i<80*40;i++)
  {	
    picL=*(p+i*2);	//ݵλǰ
    picH=*(p+i*2+1);				
    LCD_WriteData_16Bit(picH<<8|picL);  						
  }	
}