#include <ioCC2530.h>
#include <stdio.h>
#include "delay.h"
#include "uart.h"
#include "dht11.h"
#include "SPI_TFT.H"

// ϵͳʱӳʼ
void initClock(void) {
    CLKCONCMD &= ~0x40;
    while(CLKCONSTA & 0x40);
    CLKCONCMD &= ~0x07;
}

// ʾ̬棨ִֻһΣ
void displayStaticUI(void) {
    // ʾɫ
    Color = WHITE;
    Color_BK = BLUE;
    
    // ʾ
    LCD_write_CN_string(20, 10, "ʪȼ");
    
    // ʾ̬ǩ
    Color = YELLOW;
    Color_BK = BLUE;
    LCD_write_CN_string(15, 40, "¶ȣ");
    
    Color = GREEN;
    Color_BK = BLUE;
    LCD_write_CN_string(15, 60, "ʪȣ");
    
    Color = WHITE;
    Color_BK = BLUE;
    LCD_write_CN_string(15, 85, "״̬");
    
    // һ߿
    DrawRect(5, 5, 118, 110, WHITE);
}

// ֲˢʪ
void refreshTempHumidityData(void) {
    char tempStr[20];
    char humidStr[20];
    
    // ʽ¶ַ
    sprintf(tempStr, "T:%d.%dC", temperature_int, temperature_dec);
    
    // ʽʪַ  
    sprintf(humidStr, "H:%d.%d%%", humidity_int, humidity_dec);
    
    // ñɫ䣩
    DrawRectFill(60, 40, 60, 14, BLUE);  // ¶
    DrawRectFill(60, 60, 60, 14, BLUE);  // ʪ
    DrawRectFill(60, 85, 60, 14, BLUE);  // ״̬
    
    // ʾ¶
    Color = YELLOW;
    Color_BK = BLUE;
    LCD_write_EN_string(60, 40, tempStr);
    
    // ʾʪ
    Color = GREEN;
    Color_BK = BLUE;
    LCD_write_EN_string(60, 60, humidStr);
    
    // ʾ״̬
    Color = WHITE;
    Color_BK = BLUE;
    LCD_write_CN_string(60, 85, "");
}

// ֲˢ´״̬
void refreshErrorStatus(void) {
    // 
    DrawRectFill(60, 40, 60, 14, BLUE);  // ¶
    DrawRectFill(60, 60, 60, 14, BLUE);  // ʪ
    DrawRectFill(60, 85, 60, 14, BLUE);  // ״̬
    
    // ʾϢ
    Color = RED;
    Color_BK = BLUE;
    LCD_write_CN_string(60, 40, "ȡʧ");
    
    Color = YELLOW;
    Color_BK = BLUE;
    LCD_write_CN_string(60, 85, "");
}

// ʾʼ
void displayInitScreen(void) {
    LCD_clear(BLUE);
    // ʾɫ
    Color = WHITE;
    Color_BK = BLUE;
    // ʾ
    LCD_write_CN_string(20, 10, "ʪȼ");
    DrawRect(5, 5, 118, 110, WHITE);
    
    // ʾʼϢ
    Color = WHITE;
    Color_BK = BLUE;
    LCD_write_CN_string(20, 40, "ϵͳ");
    LCD_write_CN_string(20, 60, "Ժ򡣡");
}

void main(void) {
    char buffer[50];
    unsigned char error_count = 0;
    unsigned char last_success = 0;  // ¼һǷɹ
    
    // ʼģ
    initClock();
    initUART0();
    DHT_Init();
    InitLcd();  // ʼTFTĻ
    
    // ʾʼ
    displayInitScreen();
    
    UART0_SendString("=== DHT11 with TFT Display ===\n");
    delay_ms(2000); // ģ㹻ʱȶ
    
    // ʾ
    LCD_clear(BLUE);
    displayStaticUI();
    
    while(1) {
        if(DHT_ReadData()) {
            error_count = 0;
            
            // 
            sprintf(buffer, "T:%d.%d;H:%d;\n", 
                   temperature_int, temperature_dec, humidity_int);
            UART0_SendString(buffer);
            
            // ֲˢTFTĻ
            refreshTempHumidityData();
            last_success = 1;
            
        } else {
            error_count++;

            
            // ڴϢ
            if(error_count <= 3) {
                UART0_SendString("Read error, retrying...\n");
            } else if(error_count == 4) {
                UART0_SendString("Multiple errors - checking connection\n");
            }
            
            // ֻ״̬ıʱˢ´ʾ
            if(last_success) {
                refreshErrorStatus();
                last_success = 0;
            }
        }
        
        delay_ms(1000); // 2ȡ
    }
}