#include <ioCC2530.h>
#include "dht11.h"
#include "delay.h"
#include "uart.h"

// ȫֱ
unsigned char temperature_int = 0;
unsigned char temperature_dec = 0;
unsigned char humidity_int = 0;
unsigned char humidity_dec = 0;

void DHT_Init(void) {
    P0SEL &= ~0x10;   // P0_4ΪͨIO
    P0DIR &= ~0x10;   // ʼΪģʽ
    P0INP &= ~0x10;   // /ģʽ
    P2INP &= ~0x20;   // P0
}

void DHT_Start(void) {
    P0DIR |= 0x10;    // Ϊģʽ
    P0_4 = 0;         // 
    delay_ms(20);     // 18ms
    P0_4 = 1;         // ͷ
    delay_us(30);     // ȴ20-40us
    P0DIR &= ~0x10;   // Ϊģʽ
}

unsigned char DHT_CheckResponse(void) {
    unsigned int timeout = 10000;  // Сʱʱ
    
    // ȴDHTͣ80us
    while((P0 & 0x10) && timeout--) {
        delay_us(1);
    }
    if(timeout == 0) {
        UART0_SendString("Timeout at step 1\n");
        return 0;
    }
    
    // ȴ80us͵ƽ
    timeout = 1000;
    while(!(P0 & 0x10) && timeout--) {
        delay_us(1);
    }
    if(timeout == 0) {
        UART0_SendString("Timeout at step 2\n");
        return 0;
    }
    
    // ȴ80usߵƽ
    timeout = 1000;
    while((P0 & 0x10) && timeout--) {
        delay_us(1);
    }
    if(timeout == 0) {
        UART0_SendString("Timeout at step 3\n");
        return 0;
    }
    
    return 1;
}

unsigned char DHT_ReadByte(void) {
    unsigned char i, data = 0;
    unsigned int timeout;
    
    for(i = 0; i < 8; i++) {
        data <<= 1;
        
        // ȴ50us͵ƽ
        timeout = 1000;
        while(!(P0 & 0x10) && timeout--) {
            delay_us(1);
        }
        if(timeout == 0) return 0;
        
        // ȴ26-28us
        delay_us(30);
        
        if(P0 & 0x10) {
            data |= 1;
            // ȴߵƽ
            timeout = 1000;
            while((P0 & 0x10) && timeout--) {
                delay_us(1);
            }
        }
    }
    
    return data;
}

unsigned char DHT_ReadData(void) {
    unsigned char checksum;
    
    DHT_Start();
    
    if(!DHT_CheckResponse()) {
        UART0_SendString("DHT No response\n");
        return 0;
    }
    
    // ȡ5ֽ
    humidity_int = DHT_ReadByte();
    humidity_dec = DHT_ReadByte();
    temperature_int = DHT_ReadByte();
    temperature_dec = DHT_ReadByte();
    checksum = DHT_ReadByte();
    
    // У
    unsigned char sum = humidity_int + humidity_dec + temperature_int + temperature_dec;
    if(checksum == sum) {
        return 1;
    } else {
        UART0_SendString("Checksum error\n");
        return 0;
    }
}